<?php
include_once './config.php';

$api_key = "05e5ac25d86592f9";
$secret_key = "OTEzMTc0ODdlNzFjNjQ4YjMyM2I5NTFlODQ0M2VmNTZmNjMyODQxMDZhNmQ4NTZiMjQ4N2E3N2EyMWQyMjkwNA==";
$sender_name = "Akhothec";

$current_date = date('Y-m-d');
$reminder_date = date('Y-m-d', strtotime('+2 days'));

$query = "SELECT ls.id, ls.user_id, ls.loan_id, ls.date, ls.scheduled_amount, ls.paid_amount, u.first_name, u.last_name, u.phone 
          FROM loan_schedule ls
          JOIN users u ON ls.user_id = u.id
          WHERE ls.status = 'Pending' AND (ls.date = ? OR ls.date = ?);";

$stmt = $conn->prepare($query);
$stmt->bind_param("ss", $reminder_date, $current_date);
$stmt->execute();
$result = $stmt->get_result();

$sent_messages = [];

while ($row = $result->fetch_assoc()) {
    $due_amount = $row['scheduled_amount'] - $row['paid_amount'];
    $message = "Ndugu mteja " . $row['first_name'] . " " . $row['last_name'] . ", unakumbushwa kufanya rejesho lako la kiasi " . number_format($due_amount, 2) . " Tarehe " . $row['date'] . ".";
    
    sendSMS($row['phone'], $message, $api_key, $secret_key, $sender_name);
    
    $sent_messages[] = [
        'first_name' => $row['first_name'],
        'last_name' => $row['last_name'],
        'phone' => $row['phone'],
        'message' => $message
    ];
}

$stmt->close();
$conn->close();

echo json_encode(['success' => true, 'message' => 'Reminders sent successfully', 'sent_messages' => $sent_messages]);

function sendSMS($phone, $message, $api_key, $secret_key, $sender_name) {
    $url = "https://api.beem.africa/v1/send";
    $data = [
        "recipients" => [
            ["recipient_id" => "1", "dest_addr" => $phone, "message" => $message]
        ],
        "sender" => $sender_name
    ];
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json",
        "Authorization: Basic " . base64_encode("$api_key:$secret_key")
    ]);
    
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}
?>