<?php

require_once '../config.php'; // Ensure you have the correct path for your database connection

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get the input data
    $first_name = $_POST['first_name'];
    $last_name = $_POST['last_name'];
    $phone = $_POST['phone']; // Phone input
    $password = $_POST['password'];
    $address = $_POST['adress']; // Address input
    $email = isset($_POST['email']) ? $_POST['email'] : null; // Optional email field

    // Check if phone number already exists
    $check_phone_sql = "SELECT * FROM users WHERE phone = ?";
    $stmt = $conn->prepare($check_phone_sql);
    $stmt->bind_param('s', $phone);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Phone number already used
        echo json_encode(["success" => false, "message" => "Phone number already registered"]);
    } else {
        // Check if email is provided and exists in the database (optional)
        if ($email) {
            $check_email_sql = "SELECT * FROM users WHERE email = ?";
            $stmt = $conn->prepare($check_email_sql);
            $stmt->bind_param('s', $email);
            $stmt->execute();
            $email_result = $stmt->get_result();

            if ($email_result->num_rows > 0) {
                // Email already used
                echo json_encode(["success" => false, "message" => "Email already registered"]);
                exit;
            }
        }

        // Hash the password
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);

        // Prepare SQL statement to insert user data
        $sql = "INSERT INTO users (first_name, last_name, phone, password, email, adress, type, status, created_at) 
                VALUES (?, ?, ?, ?, ?, ?, '0', '0', NOW())";
        
        // Prepare and bind
        if ($stmt = $conn->prepare($sql)) {
            $stmt->bind_param('ssssss', $first_name, $last_name, $phone, $hashed_password, $email, $address);

            // Execute the query
            if ($stmt->execute()) {
                // Registration successful
                echo json_encode(["success" => true, "message" => "Registration successful"]);
            } else {
                // Registration failed
                echo json_encode(["success" => false, "message" => "Registration failed. Please try again."]);
            }

            // Close the statement
            $stmt->close();
        }
    }

    // Close the connection
    $conn->close();
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
}


?>
