<?php
// Include database connection
include '../config.php';

// Set the response type to JSON
header('Content-Type: application/json');

// Check if buyer_id is provided
if (isset($_GET['buyer_id']) || isset($_POST['buyer_id'])) {
    // Get the buyer_id from GET or POST request
    $buyer_id = isset($_GET['buyer_id']) ? $_GET['buyer_id'] : $_POST['buyer_id'];

    // Sanitize the input to prevent SQL injection
    $buyer_id = $conn->real_escape_string($buyer_id);

    // Query to get orders for the given buyer_id
    $orderQuery = "SELECT id, buyer_id, total_amount, order_date, status FROM orders WHERE buyer_id = '$buyer_id'";
    
    // Execute the query
    $result = $conn->query($orderQuery);

    // Check if any orders are found
    if ($result->num_rows > 0) {
        $orders = [];

        // Fetch each order
        while ($order = $result->fetch_assoc()) {
            $orderId = $order['id'];
            $orderItems = [];

            // Query to get items for the specific order, including product name
            $itemQuery = "
                SELECT oi.product_id, oi.quantity, oi.price, p.name AS product_name
                FROM order_items oi
                JOIN product p ON oi.product_id = p.id
                WHERE oi.order_id = '$orderId'
            ";
            $itemResult = $conn->query($itemQuery);

            if ($itemResult->num_rows > 0) {
                // Fetch order items with product name
                while ($item = $itemResult->fetch_assoc()) {
                    $orderItems[] = $item;
                }
            }

            // Add order to orders array
            $orders[] = [
                'order_id' => $order['id'],
                'order_number' => 'ODR/' . date('Y') . '/' . $order['id'], // Random order number format
                'total_amount' => $order['total_amount'],
                'order_date' => $order['order_date'],
                'status' => $order['status'], // 0 = Pending, 1 = Processing, 2 = Completed
                'items' => $orderItems, // Associated items for the order
            ];
        }

        // Return orders data as JSON
        echo json_encode([
            'status' => 'success',
            'orders' => $orders,
        ]);
    } else {
        // No orders found
        echo json_encode([
            'status' => 'error',
            'message' => 'No orders found for this user.',
        ]);
    }
} else {
    // No buyer_id provided
    echo json_encode([
        'status' => 'error',
        'message' => 'Buyer ID is required.',
    ]);
}

// Close the database connection
$conn->close();
?>
