<?php
header('Content-Type: application/json');
require '../config.php';

$user_id = $_GET['user_id'];

// Define the base URL for images
$baseUrl = 'https://api.almega.co.tz/';

$query = "SELECT 
            la.*, 
            p.name AS product_name, 
            la.total_loan_amount AS loan_price, 
            p.cover_image, 
            IFNULL(SUM(id.amount), 0) AS initial_deposit_paid,
            IFNULL(SUM(r.amount), 0) AS total_repayments,
            (la.total_loan_amount - IFNULL(SUM(r.amount), 0)) AS remaining_balance
          FROM loan_applications la
          JOIN product p ON la.product_id = p.id
          LEFT JOIN initial_deposits id ON la.id = id.loan_id
          LEFT JOIN repayments r ON la.id = r.loan_id
          WHERE la.user_id = ?
          GROUP BY la.id";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$loans = [];
while ($row = $result->fetch_assoc()) {
    // Fetch loan schedules
    $schedule_query = "SELECT date, status, scheduled_amount FROM loan_schedule WHERE loan_id = ?";
    $schedule_stmt = $conn->prepare($schedule_query);
    $schedule_stmt->bind_param("i", $row['id']);
    $schedule_stmt->execute();
    $schedule_result = $schedule_stmt->get_result();

    $schedules = [];
    while ($schedule_row = $schedule_result->fetch_assoc()) {
        $schedules[] = [
            'date' => $schedule_row['date'],
            'status' => $schedule_row['status'],
            'scheduled_amount' => (float)$schedule_row['scheduled_amount'],
        ];
    }

    // Add product image URL
    $product_image_url = $baseUrl . $row['cover_image'];

    $loans[] = [
        'id' => $row['id'],
        'user_id' => $row['user_id'],
        'product_id' => $row['product_id'],
        'full_name' => $row['full_name'],
        'phone_number' => $row['phone_number'],
        'national_id' => $row['national_id'],
        'reason' => $row['reason'],
        'document_path' => $row['document_path'],
        'application_date' => $row['application_date'],
        'status' => $row['status'],
        'product_name' => $row['product_name'],
        'loan_price' => (float)$row['loan_price'],
        'initial_deposit_paid' => (float)$row['initial_deposit_paid'],
        'total_repayments' => (float)$row['total_repayments'],
        'remaining_balance' => (float)$row['remaining_balance'],
        'product_image_url' => $product_image_url,
        'schedules' => $schedules, // Include loan schedules
    ];
}

echo json_encode($loans);

$conn->close();
?>
