<?php
// Allow CORS requests
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

// Include database connection file
require_once '../config.php'; 

// Check if request method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get the input data
    $identifier = $_POST['identifier']; // Phone or email
    $password = $_POST['password'];
    $isPhoneLogin = $_POST['isPhoneLogin']; // Check if login is by phone or email

    // Prepare SQL statement to check user existence
    if ($isPhoneLogin == 'true') {
        // Login by phone
        $sql = "SELECT id, password FROM users WHERE phone = ?";
    } else {
        // Login by email
        $sql = "SELECT id, password FROM users WHERE email = ?";
    }

    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param('s', $identifier);
        $stmt->execute();
        $result = $stmt->get_result();

        // Check if user exists
        if ($result->num_rows > 0) {
            $user = $result->fetch_assoc();

            // Verify the password
            if (password_verify($password, $user['password'])) {
                // Login successful
                echo json_encode([
                    "success" => true,
                    "message" => "Login successful",
                    "user_id" => $user['id']
                ]);
            } else {
                // Incorrect password
                echo json_encode([
                    "success" => false,
                    "message" => "Incorrect password"
                ]);
            }
        } else {
            // User not found
            echo json_encode([
                "success" => false,
                "message" => "User not found"
            ]);
        }

        // Close the statement
        $stmt->close();
    } else {
        echo json_encode([
            "success" => false,
            "message" => "Database query failed"
        ]);
    }

    // Close the connection
    $conn->close();
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
?>
