<?php
header('Content-Type: application/json');
include '../config.php'; 

$productId = $_GET['id'];
$sql = "SELECT id, name, description, cover_image, price, loan_price FROM product WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $productId);
$stmt->execute();
$result = $stmt->get_result();

$product = $result->fetch_assoc();

// Update the cover_image to include the base URL
if ($product) {
    $base_url = "https://api.almega.co.tz/";
    // Ikiwa cover_image ni null au empty, weka default image
    $product['cover_image'] = !empty($product['cover_image']) 
        ? $base_url . $product['cover_image'] 
        : $base_url . 'uploads/logo.png';
}

echo json_encode($product);

$stmt->close();
$conn->close();
?>
