<?php
header('Content-Type: application/json');
include '../config.php';

$productId = $_GET['product_id'];
$sql = "SELECT image FROM product_gallery WHERE product_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $productId);
$stmt->execute();
$result = $stmt->get_result();

$images = [];
$base_url = "https://api.almega.co.tz/"; // Base URL for images

while ($row = $result->fetch_assoc()) {
    $images[] = $base_url . $row['image']; // Append base URL to each image
}

// Ikiwa hakuna gallery image, weka default image
if (empty($images)) {
    $images[] = "https://api.almega.co.tz/uploads/logo.png";
}

echo json_encode(['images' => $images]);

$stmt->close();
$conn->close();
?>
