<?php
include '../config.php'; 

header('Content-Type: application/json');

// Define the base URL for the images
$baseUrl = 'https://api.almega.co.tz/'; // Make sure to adjust the base path if needed

// Query to fetch product data
$sql = "SELECT id, name, cover_image, old_price, price, category, orders FROM product WHERE 1 ORDER BY created_at DESC";
$result = $conn->query($sql);

$products = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $orders = $row['orders'];
        
        // Generate a random rating based on orders
        $rating = 2 + (mt_rand() / mt_getrandmax()) * 3; // Generates a random float between 2 and 5
        
        // Ikiwa cover_image ni null au empty, weka default image
        $coverImage = !empty($row['cover_image']) ? $row['cover_image'] : 'uploads/logo.png';

        $products[] = [
            'id' => $row['id'],
            'name' => $row['name'],
            'imageUrl' => $baseUrl . $coverImage,
            'price' => (float)$row['price'],
            'oldPrice' => (float)$row['old_price'],
            'category' => $row['category'],
            'orders' => (int)$orders,
            'rating' => round($rating, 1), // Round to 1 decimal place
        ];
    }
}

echo json_encode(['products' => $products]);

$conn->close();
?>
