<?php
header('Content-Type: application/json');
include '../config.php';

$data = json_decode(file_get_contents("php://input"));

// Check if data is valid and not null
if ($data === null) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid data']);
    exit;
}

$buyer_id = $data->buyer_id ?? null;
$items = $data->items ?? null;  // Array of items (product_id, quantity, price)

// Check if any required data is missing
if ($buyer_id === null || $items === null || !is_array($items)) {
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields']);
    exit;
}

// Calculate the total amount
$total_amount = 0;
foreach ($items as $item) {
    $total_amount += $item->price * $item->quantity;
}

// Insert into orders table
$sql = "INSERT INTO orders (buyer_id, total_amount) VALUES (?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("id", $buyer_id, $total_amount);
$stmt->execute();

if ($stmt->affected_rows > 0) {
    // Get the newly created order_id
    $order_id = $stmt->insert_id;

    // Insert items into order_items table with product_id, quantity, and price
    $sql_item = "INSERT INTO order_items (order_id, product_id, quantity, price) VALUES (?, ?, ?, ?)";
    $stmt_item = $conn->prepare($sql_item);

    foreach ($items as $item) {
        $stmt_item->bind_param("iiii", $order_id, $item->product_id, $item->quantity, $item->price);
        $stmt_item->execute();
    }

    echo json_encode(['status' => 'success', 'order_id' => $order_id]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to place order']);
}

$stmt->close();
$conn->close();
?>
