<?php
include '../config.php';  // Include database connection

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get the input values
    $user_id = $_POST['user_id'];
    $product_id = $_POST['product_id'];
    $full_name = $_POST['full_name'];
    $phone_number = $_POST['phone_number'];
    $national_id = $_POST['national_id'];
    $reason = $_POST['reason'];
    $weeks = $_POST['weeks'];
    $total_loan_amount = $_POST['total_loan_amount']; // New parameter

    // Check if file is uploaded
    if (isset($_FILES['document']) && $_FILES['document']['error'] == 0) {
        $file_tmp_name = $_FILES['document']['tmp_name'];
        $file_name = $_FILES['document']['name'];
        $upload_dir = '../uploads/documents/';
        $file_path = $upload_dir . basename($file_name);
        
        // Move the uploaded file to the documents folder
        if (move_uploaded_file($file_tmp_name, $file_path)) {
            // Prepare SQL statement
            $sql = "INSERT INTO loan_applications 
                    (user_id, product_id, full_name, phone_number, national_id, reason, weeks, total_loan_amount, document_path) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

            $stmt = $conn->prepare($sql);
            $stmt->bind_param("iissssids", $user_id, $product_id, $full_name, $phone_number, $national_id, $reason, $weeks, $total_loan_amount, $file_path);
            
            if ($stmt->execute()) {
                echo json_encode(["status" => "success", "message" => "Loan application submitted successfully."]);
            } else {
                echo json_encode(["status" => "error", "message" => "Error submitting application."]);
            }
            $stmt->close();
        } else {
            echo json_encode(["status" => "error", "message" => "Failed to upload document."]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "No document uploaded."]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request method."]);
}
?>
