<?php
include '../../config.php';

header('Content-Type: application/json');

// Get the input data from POST request
$id = isset($_POST['id']) ? intval($_POST['id']) : 0;
$phone = isset($_POST['phone']) ? trim($_POST['phone']) : '';
$role = isset($_POST['role']) ? trim($_POST['role']) : '';
$status = isset($_POST['status']) ? intval($_POST['status']) : 0;

// Validate input
if ($id <= 0 || empty($phone) || empty($role)) {
    echo json_encode(['success' => false, 'message' => 'Invalid input data']);
    exit;
}

// Prepare SQL statement to update staff
$sql = "UPDATE users SET phone = ?, type = ?, status = ? WHERE id = ?";
$stmt = $conn->prepare($sql);

if ($stmt) {
    $stmt->bind_param("ssii", $phone, $role, $status, $id);

    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Staff updated successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update staff']);
    }

    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to prepare SQL statement']);
}

$conn->close();
?>
