<?php
date_default_timezone_set('Africa/Dar_es_Salaam');
header('Content-Type: application/json');
include '../../../config.php'; 

// Get the start and end date from query parameters
$startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
$endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';

// Start building the SQL query
$sql = "SELECT id, name, buy_price, price, quantity, unit, shop_id, created_at FROM product";

// If date range is provided, add it to the WHERE clause
if ($startDate && $endDate) {
    $sql .= " WHERE created_at BETWEEN '$startDate' AND '$endDate'";
}

$result = $conn->query($sql);

$stock = [];
while ($row = $result->fetch_assoc()) {
    $row['total_buy_price'] = $row['buy_price'] * $row['quantity'];
    $row['total_sell_price'] = $row['price'] * $row['quantity'];
    $stock[] = $row;
}

$response = [
    'success' => true,
    'data' => $stock
];

echo json_encode($response);
$conn->close();
?>
