<?php
header("Content-Type: application/json");

// Ongeza memory limit na maximum execution time
ini_set('memory_limit', '512M');    // au ongeza kulingana na mahitaji yako
set_time_limit(300);                // ongeza maximum execution time

include '../../../config.php'; // Hakikisha inajumuisha $conn

// Hakikisha method ni GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['status' => false, 'message' => 'Invalid Request Method']);
    exit;
}

// Pata tarehe kama zipo
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : '';
$end_date   = isset($_GET['end_date']) ? $_GET['end_date'] : '';

// Andaa query ya schedule report
$query = "SELECT 
            ls.id AS schedule_id,
            ls.user_id,
            ls.loan_id,
            ls.status,
            ls.date,
            ls.scheduled_amount,
            ls.paid_amount,
            CONCAT(u.first_name, ' ', u.last_name) AS full_name,
            u.phone
          FROM loan_schedule ls
          LEFT JOIN users u ON ls.user_id = u.id
          WHERE 1";

if (!empty($start_date) && !empty($end_date)) {
    $query .= " AND ls.date BETWEEN '$start_date' AND '$end_date'";
}

$query .= " ORDER BY ls.date ASC";

// Endesha query
$result = mysqli_query($conn, $query);
if (!$result) {
    echo json_encode(['status' => false, 'message' => 'Database Query Failed']);
    exit;
}

// Tumia mysqli_fetch_all kama inapatikana
$schedule_reports = mysqli_fetch_all($result, MYSQLI_ASSOC);

$response = [
    'status' => true,
    'data'   => $schedule_reports
];

// Hakikisha json_encode inafanya kazi vizuri
$json = json_encode($response);
if ($json === false) {
    echo json_encode([
        'status' => false,
        'message' => 'JSON encoding error: ' . json_last_error_msg()
    ]);
    exit;
}

echo $json;
?>
