<?php
header("Content-Type: application/json");
include '../../../config.php'; // Hakikisha inajumuisha $conn

// Hakikisha method ni GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['status' => false, 'message' => 'Invalid Request Method']);
    exit;
}

// Pata tarehe kama zipo
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : '';
$end_date   = isset($_GET['end_date']) ? $_GET['end_date'] : '';

// Andaa query ya marejesho
$query = "SELECT 
            r.id AS repayment_id, 
            la.id AS loan_id, 
            la.full_name, 
            CONCAT(u.first_name, ' ', u.last_name) AS account_name,
            p.name AS product_name,
            r.amount AS repayment_amount,
            la.total_loan_amount,
            r.payment_date
          FROM repayments r
          LEFT JOIN loan_applications la ON r.loan_id = la.id
          LEFT JOIN users u ON la.user_id = u.id
          LEFT JOIN product p ON la.product_id = p.id
          WHERE 1";

if (!empty($start_date) && !empty($end_date)) {
    $query .= " AND r.payment_date BETWEEN '$start_date' AND '$end_date'";
}

// Tulipanga kwa loan_id na tarehe la malipo katika mpangilio wa ascending
$query .= " ORDER BY la.id ASC, r.payment_date ASC";

// Endesha query
$result = mysqli_query($conn, $query);
if (!$result) {
    echo json_encode(['status' => false, 'message' => 'Database Query Failed']);
    exit;
}

$repayment_reports = [];
$unique_loans = [];           // Hifadhi data ya kila mkopo (avoid duplicate loan amount)
$cumulative_repayments = [];  // Hifadhi jumla ya marejesho ya kila mkopo hadi sasa

while ($row = mysqli_fetch_assoc($result)) {
    $loan_id = $row['loan_id'];
    $repayment_amount = floatval($row['repayment_amount']);
    $total_loan_amount = floatval($row['total_loan_amount']);
    
    // Hesabu marejesho ya mkopo kumaanisha kuhesabu malipo kwa mtiririko
    if (!isset($cumulative_repayments[$loan_id])) {
        $cumulative_repayments[$loan_id] = 0;
    }
    $cumulative_repayments[$loan_id] += $repayment_amount;
    
    // Hesabu salio lililobaki kwa mkopo wakati huo
    $row['remaining_balance'] = $total_loan_amount - $cumulative_repayments[$loan_id];
    
    // Tunatumia uwanja 'total_repayments' kuonyesha kiasi cha malipo katika record hiyo (si jumla ya mkopo yote)
    $row['total_repayments'] = $repayment_amount;
    
    $repayment_reports[] = $row;
    
    // Kukusanya data kwa ajili ya summary (kila mkopo inahesabiwa mara moja)
    if (!isset($unique_loans[$loan_id])) {
        $unique_loans[$loan_id] = [
            'total_loan_amount' => $total_loan_amount,
            'total_repayments'  => $repayment_amount
        ];
    } else {
        $unique_loans[$loan_id]['total_repayments'] += $repayment_amount;
    }
}

$totalLoanAmountSummary = 0;
$totalRepaymentsSummary = 0;
$totalRemainingBalanceSummary = 0;

foreach ($unique_loans as $loan_id => $values) {
    $loanTotal = $values['total_loan_amount'];
    $repaymentsTotal = $values['total_repayments'];
    $remaining = $loanTotal - $repaymentsTotal;
    
    $totalLoanAmountSummary += $loanTotal;
    $totalRepaymentsSummary  += $repaymentsTotal;
    $totalRemainingBalanceSummary += $remaining;
}

$response = [
    'status' => true,
    'data'   => $repayment_reports,
    'summary' => [
         'total_loan_amount'      => $totalLoanAmountSummary,
         'total_repayments'       => $totalRepaymentsSummary,
         'total_remaining_balance'=> $totalRemainingBalanceSummary
    ]
];

echo json_encode($response);
?>
