<?php
date_default_timezone_set('Africa/Dar_es_Salaam');
header('Content-Type: application/json');

// Include your database connection file
include '../../../config.php';

// Function to fetch purchase reports
function getPurchaseReports($conn, $startDate, $endDate) {
    // Query to get all products within the date range
    $productQuery = "
        SELECT 
            p.id,
            p.shop_id,
            p.name AS product_name,
            p.buy_price,
            p.created_at AS purchase_date
        FROM product p
    ";

    $result = $conn->query($productQuery);

    // Initialize an empty array to store the purchase reports
    $purchaseReports = array();

    if ($result->num_rows > 0) {
        // Loop through the products
        while ($row = $result->fetch_assoc()) {
            // Get the product ID to track changes
            $productId = $row['id'];

            // Query to get changes (additions) from the quantity_changes table within the given date range
            $changesQuery = "
                SELECT 
                    SUM(pc.quantity) AS total_quantity
                FROM quantity_changes pc
                WHERE pc.product_id = $productId
                AND (pc.type = 'increase' OR pc.type = 'add')
                AND pc.date BETWEEN '$startDate' AND '$endDate'
            ";

            $changesResult = $conn->query($changesQuery);
            $changeRow = $changesResult->fetch_assoc();
            $totalQuantity = (int)($changeRow['total_quantity'] ?? 0);

            // Calculate total cost
            $totalCost = (float)$row['buy_price'] * $totalQuantity;

            // Prepare a purchase report for this product
            $purchaseReport = array(
                'id' => (string)$row['id'] ?? '0', // Fallback to '0'
                'shop_id' => (string)$row['shop_id'] ?? '0',
                'product_name' => $row['product_name'] ?? 'Unknown', // Ensure it is a string
                'buy_price' => (string)$row['buy_price'] ?? '0', // Ensure it is a string
                'quantity' => (string)$totalQuantity, // Convert to string
                'total_cost' => (string)$totalCost, // Add total cost
                'purchase_date' => $row['purchase_date'] ?? date('Y-m-d H:i:s') // Use current time if null
            );

            // Add the report to the list
            if ($totalQuantity > 0) { // Only include products with recorded purchases
                $purchaseReports[] = $purchaseReport;
            }
        }
    }

    // Return the reports as JSON
    echo json_encode($purchaseReports);
}

// Get date parameters from the request (you can use GET or POST method)
$startDate = isset($_GET['start_date']) ? $_GET['start_date'] : null;
$endDate = isset($_GET['end_date']) ? $_GET['end_date'] : null;

if ($startDate && $endDate) {
    // Call the function to get purchase reports
    getPurchaseReports($conn, $startDate, $endDate);
} else {
    echo json_encode(["error" => "Please provide start_date and end_date"]);
}

// Close the database connection
$conn->close();
?>
