<?php
date_default_timezone_set('Africa/Dar_es_Salaam');
header('Content-Type: application/json');
include '../../../config.php'; // Include your database connection file

function getProductReport($conn, $startDate, $endDate) {
    // Hakikisha tarehe zipo sahihi
    if (!$startDate || !$endDate) {
        echo json_encode(["error" => "Start date and end date are required"]);
        return;
    }

    // Query ya kupata bidhaa zilizouzwa ndani ya tarehe husika kwa order zenye status 1 au 2
    $productReportQuery = "
        SELECT p.id, p.name, p.shop_id, COALESCE(SUM(oi.quantity), 0) AS total_sold
        FROM product p
        LEFT JOIN order_items oi ON p.id = oi.product_id
        LEFT JOIN orders o ON oi.order_id = o.id
        WHERE o.status IN (1, 2) 
        AND o.order_date BETWEEN ? AND ?
        GROUP BY p.id, p.name
        ORDER BY total_sold DESC
    ";

    // Prepare statement
    $stmt = $conn->prepare($productReportQuery);
    $stmt->bind_param("ss", $startDate, $endDate);
    $stmt->execute();
    $result = $stmt->get_result();

    $products = [];
    while ($row = $result->fetch_assoc()) {
        $products[] = $row;
    }

    // Return JSON response
    echo json_encode($products);

    $stmt->close();
}

// Pata tarehe kutoka kwenye request
$startDate = isset($_GET['start_date']) ? $_GET['start_date'] : null;
$endDate = isset($_GET['end_date']) ? $_GET['end_date'] : null;

// Call function ya kupata ripoti ya bidhaa
getProductReport($conn, $startDate, $endDate);

// Funga connection
$conn->close();
?>
