<?php
header('Content-Type: application/json');
include '../../../config.php';

$startDate = isset($_GET['startDate']) ? $_GET['startDate'] : null;
$endDate = isset($_GET['endDate']) ? $_GET['endDate'] : null;

if (!$startDate || !$endDate) {
    echo json_encode(["error" => "Invalid date range"]);
    exit;
}

// Query for total sales and total cost (Gross Profit)
$query = "SELECT 
            SUM(o.total_amount) AS totalSales,
            SUM(p.buy_price * oi.quantity) AS totalCost
          FROM orders o
          JOIN order_items oi ON o.id = oi.order_id
          JOIN product p ON oi.product_id = p.id
          WHERE DATE(o.order_date) BETWEEN ? AND ?
          AND o.status IN (1, 2)";

$stmt = $conn->prepare($query);
$stmt->bind_param("ss", $startDate, $endDate);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();

$totalSales = $data['totalSales'] ?? 0;
$totalCost = $data['totalCost'] ?? 0;
$grossProfit = $totalSales - $totalCost;

// Query for total expenses
$expenseQuery = "SELECT SUM(amount) AS totalExpenses FROM expenses WHERE DATE(created_at) BETWEEN ? AND ?";
$stmt = $conn->prepare($expenseQuery);
$stmt->bind_param("ss", $startDate, $endDate);
$stmt->execute();
$expenseResult = $stmt->get_result();
$expenseData = $expenseResult->fetch_assoc();

$totalExpenses = $expenseData['totalExpenses'] ?? 0;

// Net Profit = Gross Profit - Expenses
$netProfit = $grossProfit - $totalExpenses;

echo json_encode([
    "totalSales" => $totalSales,
    "grossProfit" => $grossProfit,
    "totalExpenses" => $totalExpenses,
    "netProfit" => $netProfit
]);

$stmt->close();
$conn->close();
?>
