<?php
date_default_timezone_set('Africa/Dar_es_Salaam');
header('Content-Type: application/json');

// Jumuisha connection ya database
include '../../../config.php';

// Fungua connection na uhakikishe method ya request ni GET
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    // Pata tarehe za mwanzo na mwisho kutoka kwenye URL parameters
    $start_date = isset($_GET['start_date']) ? $_GET['start_date'] : date('Y-m-01');  // Tarehe ya kwanza ya mwezi
    $end_date = isset($_GET['end_date']) ? $_GET['end_date'] : date('Y-m-d');  // Tarehe ya leo

    // Query ya kupata mauzo kati ya tarehe hizo mbili
    $sql_sales = "SELECT o.id, o.user_id, o.total_amount, o.shop_id, o.order_date 
                  FROM orders o 
                  WHERE DATE(o.order_date) BETWEEN '$start_date' AND '$end_date' AND '$end_date'
                  AND (o.status = 1 OR o.status = 2)";


    $result_sales = mysqli_query($conn, $sql_sales);

    $sales_data = array();
    $total_sales_amount = 0;  // Variable ya kuhifadhi jumla ya mauzo

    if (mysqli_num_rows($result_sales) > 0) {
        while ($row_sales = mysqli_fetch_assoc($result_sales)) {
            $sale_id = $row_sales['id'];

            // Jumlisha total amount ya sale husika kwenye jumla ya mauzo
            $total_sales_amount += $row_sales['total_amount'];

            // Query ya kupata items zote za sale husika pamoja na jina la product
            $sql_items = "SELECT oi.product_id, oi.quantity, oi.price, p.name as product_name
                          FROM order_items oi
                          JOIN product p ON oi.product_id = p.id
                          WHERE oi.order_id = '$sale_id'";

            $result_items = mysqli_query($conn, $sql_items);

            $items = array();

            if (mysqli_num_rows($result_items) > 0) {
                while ($row_items = mysqli_fetch_assoc($result_items)) {
                    $items[] = $row_items;
                }
            }

            // Unganisha sales data na items
            $row_sales['items'] = $items;
            $sales_data[] = $row_sales;
        }

        // Onyesha data kama JSON na ongeza jumla ya mauzo
        echo json_encode(array('status' => 'success', 'sales' => $sales_data, 'total_sales' => $total_sales_amount));
    } else {
        echo json_encode(array('status' => 'error', 'message' => 'No sales found for the selected period.'));
    }
} else {
    echo json_encode(array('status' => 'error', 'message' => 'Invalid request method.'));
}
?>
