<?php
header("Content-Type: application/json");
include '../../../config.php'; // Hakikisha inahusisha $conn

// Hakikisha ombi ni GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['status' => false, 'message' => 'Invalid Request Method']);
    exit;
}

// Pata parameters za date range ikiwa zipo
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : '';
$end_date   = isset($_GET['end_date']) ? $_GET['end_date'] : '';

// Tengeneza query ya SQL
$query = "SELECT la.id, 
                 la.full_name, 
                 la.phone_number, 
                 la.weeks, 
                 la.total_loan_amount, 
                 la.application_date, 
                 la.status,
                 CONCAT(u.first_name, ' ', u.last_name) AS account_name,
                 p.name AS product_name,
                 COALESCE(id.amount, 0) AS initial_deposit,
                 COALESCE(SUM(r.amount), 0) AS total_repayments
          FROM loan_applications la
          LEFT JOIN users u ON la.user_id = u.id
          LEFT JOIN product p ON la.product_id = p.id
          LEFT JOIN initial_deposits id ON la.id = id.loan_id
          LEFT JOIN repayments r ON la.id = r.loan_id
          WHERE 1";

if (!empty($start_date) && !empty($end_date)) {
    $query .= " AND la.application_date BETWEEN '$start_date' AND '$end_date'";
}

$query .= " GROUP BY la.id ORDER BY la.application_date DESC";

// Endesha query
$result = mysqli_query($conn, $query);
if (!$result) {
    echo json_encode(['status' => false, 'message' => 'Database Query Failed']);
    exit;
}

$loan_reports = [];
$total_loan_amount = 0;
while ($row = mysqli_fetch_assoc($result)) {
    // Kiasi kilichobaki = total loan - (kianzio + marejesho)
    $remaining_balance = floatval($row['total_loan_amount']) - 
                         (floatval($row['initial_deposit']) + floatval($row['total_repayments']));

    $total_loan_amount += floatval($row['total_loan_amount']);
    $row['remaining_balance'] = $remaining_balance; // Ongeza kwenye array
    $loan_reports[] = $row;
}

// Andaa summary ya report
$response = [
    'status' => true,
    'data'   => $loan_reports,
    'summary' => [
         'total_loan_amount' => $total_loan_amount,
         'approved' => 0,
         'rejected' => 0,
         'pending'  => 0
    ]
];

foreach ($loan_reports as $loan) {
    if ($loan['status'] == 'approved') {
         $response['summary']['approved']++;
    } elseif ($loan['status'] == 'rejected') {
         $response['summary']['rejected']++;
    } elseif ($loan['status'] == 'pending') {
         $response['summary']['pending']++;
    }
}

echo json_encode($response);
?>
