<?php
header('Content-Type: application/json');
include '../../../config.php';

$startDate = isset($_GET['startDate']) ? $_GET['startDate'] : null;
$endDate = isset($_GET['endDate']) ? $_GET['endDate'] : null;

if (!$startDate || !$endDate) {
    echo json_encode(["error" => "Invalid date range"]);
    exit;
}

// Pata total sales na total cost kwa orders zilizo na status 1 au 2
$query = "SELECT 
            SUM(o.total_amount) AS totalSales,
            SUM(p.buy_price * oi.quantity) AS totalCost
          FROM orders o
          JOIN order_items oi ON o.id = oi.order_id
          JOIN product p ON oi.product_id = p.id
          WHERE DATE(o.order_date) BETWEEN ? AND ?
          AND o.status IN (1, 2)"; 

$stmt = $conn->prepare($query);
$stmt->bind_param("ss", $startDate, $endDate);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();

$totalSales = $data['totalSales'] ?? 0;
$totalCost = $data['totalCost'] ?? 0;
$grossProfit = $totalSales - $totalCost;

echo json_encode([
    "totalSales" => $totalSales,
    "grossProfit" => $grossProfit
]);

$stmt->close();
$conn->close();
?>
