<?php
date_default_timezone_set('Africa/Dar_es_Salaam');
include '../../../config.php'; 

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $start_date = isset($_GET['start_date']) ? $_GET['start_date'] : '';
    $end_date = isset($_GET['end_date']) ? $_GET['end_date'] : '';

    if (empty($start_date) || empty($end_date)) {
        echo json_encode(['success' => false, 'message' => 'Tafadhali chagua tarehe sahihi']);
        exit;
    }

    $sql = "SELECT e.id, e.user_id, e.shop_id, u.first_name, u.last_name, e.type, e.amount, e.description, e.user, e.created_at 
            FROM expenses e 
            JOIN users u ON e.user_id = u.id 
            WHERE e.created_at BETWEEN ? AND ? 
            ORDER BY e.created_at DESC";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param('ss', $start_date, $end_date);
    $stmt->execute();
    $result = $stmt->get_result();

    $expenses = [];
    while ($row = $result->fetch_assoc()) {
        $expenses[] = $row;
    }

    echo json_encode(['success' => true, 'expenses' => $expenses]);
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}

$conn->close();
?>
