<?php
// annual_turnover.php
include '../../../config.php';

// Pata parameters (GET method)
$start_date = isset($_GET['start_date']) ? mysqli_real_escape_string($conn, $_GET['start_date']) : null;
$end_date   = isset($_GET['end_date']) ? mysqli_real_escape_string($conn, $_GET['end_date']) : null;

// Tengeneza masharti ya query (Filtering kwa tarehe tu)
$where = "WHERE o.status IN (1, 2)";
if ($start_date !== null && $end_date !== null && $start_date !== '' && $end_date !== '') {
    $where .= " AND o.order_date BETWEEN '$start_date' AND '$end_date'";
}

// Query ya kuhesabu total turnover
$query = "SELECT SUM(oi.quantity * oi.price) AS totalTurnover
          FROM orders o
          JOIN order_items oi ON o.id = oi.order_id
          $where";

$result = mysqli_query($conn, $query);

if ($result) {
    $row = mysqli_fetch_assoc($result);
    $totalTurnover = $row['totalTurnover'] ? $row['totalTurnover'] : 0;
    echo json_encode([
        'status'     => 'success',
        'totalSales' => $totalTurnover
    ]);
} else {
    echo json_encode([
        'status'  => 'error',
        'message' => mysqli_error($conn)
    ]);
}

mysqli_close($conn);
?>
