<?php
include_once '../../config.php'; 

header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"));

if (isset($data->loan_id) && isset($data->user_id) && isset($data->amount)) {
    $loan_id = $data->loan_id;
    $user_id = $data->user_id;
    $amount = $data->amount;
    $payment_date = isset($data->payment_date) ? $data->payment_date : date('Y-m-d');
    
    $conn->begin_transaction(); // Anza transaction
    
    try {
        // Pata schedule ya mkopo kwa order
        $query = "SELECT id, scheduled_amount, paid_amount, status FROM loan_schedule 
                  WHERE loan_id = ? AND user_id = ? ORDER BY date ASC";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("ii", $loan_id, $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows == 0) {
            throw new Exception("No loan schedule found.");
        }
        
        while ($row = $result->fetch_assoc()) {
            if ($amount <= 0) break;
            
            $schedule_id = $row['id'];
            $scheduled_amount = $row['scheduled_amount'];
            $paid_amount = $row['paid_amount'];
            $remaining_amount = $scheduled_amount - $paid_amount;
            
            if ($remaining_amount > 0) {
                if ($amount >= $remaining_amount) {
                    $new_paid_amount = $scheduled_amount;
                    $status = "Paid";
                    $amount -= $remaining_amount;
                } else {
                    $new_paid_amount = $paid_amount + $amount;
                    $status = "Pending";
                    $amount = 0;
                }
                
                $updateQuery = "UPDATE loan_schedule SET paid_amount = ?, status = ? WHERE id = ?";
                $updateStmt = $conn->prepare($updateQuery);
                $updateStmt->bind_param("dsi", $new_paid_amount, $status, $schedule_id);
                $updateStmt->execute();
                $updateStmt->close();
            }
        }
        
        // Ingiza rekodi ya malipo
        $insertQuery = "INSERT INTO repayments (loan_id, user_id, amount, payment_date) VALUES (?, ?, ?, ?)";
        $insertStmt = $conn->prepare($insertQuery);
        $insertStmt->bind_param("iids", $loan_id, $user_id, $data->amount, $payment_date);
        $insertStmt->execute();
        $insertStmt->close();
        
        $conn->commit(); // Hakikisha mabadiliko yanawekwa kwenye database
        echo json_encode(['success' => true, 'message' => 'Repayment processed successfully']);
        
    } catch (Exception $e) {
        $conn->rollback(); // Rudisha nyuma ikiwa kuna tatizo
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
    
    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Missing required parameters']);
}

$conn->close();
?>
