<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $order_id = $_POST['order_id'];
    $status = $_POST['status'];

    if (empty($order_id) || empty($status)) {
        echo json_encode(['success' => false, 'message' => 'Invalid inputs']);
        exit;
    }

    // Check if order has already been processed
    $checkProcessed = "SELECT is_processed FROM orders WHERE id = ?";
    $stmtCheck = $conn->prepare($checkProcessed);
    $stmtCheck->bind_param("i", $order_id);
    $stmtCheck->execute();
    $resultCheck = $stmtCheck->get_result();
    $orderData = $resultCheck->fetch_assoc();

    if (!$orderData) {
        echo json_encode(['success' => false, 'message' => 'Order not found']);
        exit;
    }

    $is_processed = $orderData['is_processed'];

    // Update order status
    $sql = "UPDATE orders SET status = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $status, $order_id);

    if ($stmt->execute()) {
        // Process only if order has not been processed before
        if (($status == 1 || $status == 2) && $is_processed == 0) {
            // Fetch order items
            $queryItems = "SELECT product_id, quantity FROM order_items WHERE order_id = ?";
            $stmtItems = $conn->prepare($queryItems);
            $stmtItems->bind_param("i", $order_id);
            $stmtItems->execute();
            $resultItems = $stmtItems->get_result();

            while ($item = $resultItems->fetch_assoc()) {
                $product_id = $item['product_id'];
                $quantity = $item['quantity'];

                // Update product quantity & orders count
                $updateProduct = "UPDATE product SET quantity = quantity - ?, orders = orders + ? 
                                  WHERE id = ? AND quantity >= ?";
                $stmtUpdate = $conn->prepare($updateProduct);
                $stmtUpdate->bind_param("iiii", $quantity, $quantity, $product_id, $quantity);
                $stmtUpdate->execute();

                // Check if stock was updated successfully
                if ($stmtUpdate->affected_rows === 0) {
                    echo json_encode(['success' => false, 'message' => "Insufficient stock for product ID $product_id"]);
                    exit;
                }
            }

            // Mark order as processed
            $updateProcessed = "UPDATE orders SET is_processed = 1 WHERE id = ?";
            $stmtProcessed = $conn->prepare($updateProcessed);
            $stmtProcessed->bind_param("i", $order_id);
            $stmtProcessed->execute();
        }

        echo json_encode(['success' => true, 'message' => 'Order status updated successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update order status']);
    }

    $stmt->close();
}
?>
