<?php
include '../../config.php'; 

header('Content-Type: application/json');

// Define the base URL for the images
$baseUrl = 'https://api.almega.co.tz/'; // Adjust the base path if needed

// Query to fetch product data
$sql = "SELECT id, name, cover_image, old_price, price, buy_price, loan_price, description, category, quantity, orders 
        FROM product 
        WHERE quantity = 0 
        ORDER BY created_at DESC";

$result = $conn->query($sql);

$products = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $orders = $row['orders'];

        // Generate a random rating based on orders
        $rating = 2 + (mt_rand() / mt_getrandmax()) * 3; 

        $products[] = [
            'id' => $row['id'],
            'name' => $row['name'],
            'description' => $row['description'],
            'imageUrl' => $baseUrl . $row['cover_image'], 
            'price' => (float)$row['price'],
            'oldPrice' => (float)$row['old_price'],
            'loanPrice' => (float)$row['loan_price'],
            'buyPrice' => (float)$row['buy_price'],
            'quantity' => (int)$row['quantity'],
            'orders' => (int)$orders,
            'category' => $row['category'],
        ];
    }
}

echo json_encode(['products' => $products]);

$conn->close();
?>
