<?php
header('Content-Type: application/json');
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($_GET['order_id'])) {
        $orderId = $_GET['order_id'];

        // Get order details
        $query = "SELECT o.id, o.buyer_id, o.total_amount, o.order_date, o.status, u.first_name, u.last_name, u.phone, u.adress 
                  FROM orders o
                  JOIN users u ON o.buyer_id = u.id WHERE o.id = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param('i', $orderId);
        $stmt->execute();
        $result = $stmt->get_result();
        $order = $result->fetch_assoc();

        if ($order) {
            // Combine buyer name and phone
            $order['buyer_name'] = $order['first_name'] . ' ' . $order['last_name'];
            $order['buyer_phone'] = $order['phone'];
            $order['buyer_address'] = $order['adress']; // Make sure 'adress' is renamed to 'buyer_address'

            // Get order items with product names
            $queryItems = "SELECT oi.order_item_id, oi.product_id, oi.quantity, oi.price, p.name as product_name 
                           FROM order_items oi
                           JOIN product p ON oi.product_id = p.id
                           WHERE oi.order_id = ?";
            $stmtItems = $conn->prepare($queryItems);
            $stmtItems->bind_param('i', $orderId);
            $stmtItems->execute();
            $resultItems = $stmtItems->get_result();
            $items = [];
            while ($item = $resultItems->fetch_assoc()) {
                $items[] = $item;
            }

            // Combine order data and items
            $order['items'] = $items;

            // Remove 'first_name', 'last_name', 'phone', 'adress' from the response to avoid redundancy
            unset($order['first_name']);
            unset($order['last_name']);
            unset($order['phone']);
            unset($order['adress']);
            
            echo json_encode($order); // Send the order details as JSON
        } else {
            echo json_encode(['error' => 'Order not found']);
        }
    } else {
        // Get all orders
        $query = "SELECT id, buyer_id, total_amount, order_date, status FROM orders";
        $result = $conn->query($query);
        $orders = [];

        while ($order = $result->fetch_assoc()) {
            // Get buyer name
            $buyerId = $order['buyer_id'];
            $queryBuyer = "SELECT first_name, last_name, phone, adress FROM users WHERE id = ?";
            $stmtBuyer = $conn->prepare($queryBuyer);
            $stmtBuyer->bind_param('i', $buyerId);
            $stmtBuyer->execute();
            $resultBuyer = $stmtBuyer->get_result();
            $buyer = $resultBuyer->fetch_assoc();

            // Combine buyer name and phone
            $order['buyer_name'] = $buyer['first_name'] . ' ' . $buyer['last_name'];
            $order['buyer_phone'] = $buyer['phone'];
            $order['buyer_address'] = $buyer['adress']; // Correct field to 'adress'

            // Remove 'first_name', 'last_name', 'phone', 'adress' from the response to avoid redundancy
            unset($order['first_name']);
            unset($order['last_name']);
            unset($order['phone']);
            unset($order['adress']);

            $orders[] = $order;
        }

        echo json_encode(['orders' => $orders]);
    }
}
?>
