<?php
// Allow CORS requests
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

// Include database connection file
require_once '../../config.php'; 

// Check if request method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get the input data
    $identifier = $_POST['identifier']; // Phone or email
    $password = $_POST['password'];
    $isPhoneLogin = $_POST['isPhoneLogin']; // Check if login is by phone or email

    // Prepare SQL statement to check user existence
    if ($isPhoneLogin == 'true') {
        // Login by phone
        $sql = "SELECT id, password, type, shop_id, status FROM users WHERE phone = ?";
    } else {
        // Login by email
        $sql = "SELECT id, password, type, shop_id, status FROM users WHERE email = ?";
    }

    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param('s', $identifier);
        $stmt->execute();
        $result = $stmt->get_result();

        // Check if user exists
        if ($result->num_rows > 0) {
            $user = $result->fetch_assoc();

            // Verify the password and check if status is active
            if (password_verify($password, $user['password'])) {
                if ($user['status'] == 1) {
                    // Login successful
                    echo json_encode([
                        "success" => true,
                        "message" => "Login successful",
                        "user_id" => $user['id'],
                        "type" => $user['type'],
                        "shop_id" => $user['shop_id']
                    ]);
                } else {
                    // User not active
                    echo json_encode([
                        "success" => false,
                        "message" => "User account is inactive"
                    ]);
                }
            } else {
                // Incorrect password
                echo json_encode([
                    "success" => false,
                    "message" => "Incorrect password"
                ]);
            }
        } else {
            // User not found
            echo json_encode([
                "success" => false,
                "message" => "User not found"
            ]);
        }

        // Close the statement
        $stmt->close();
    } else {
        echo json_encode([
            "success" => false,
            "message" => "Database query failed"
        ]);
    }

    // Close the connection
    $conn->close();
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}
?>
