<?php
require_once '../../config.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (isset($_GET['loan_id'])) {
        $loan_id = intval($_GET['loan_id']);
        $query = "SELECT `id`, `user_id`, `loan_id`, `status`, `date`, `scheduled_amount`, `paid_amount` 
                  FROM `loan_schedule` 
                  WHERE `loan_id` = ?";
        
        $stmt = $conn->prepare($query);
        $stmt->bind_param("i", $loan_id);
        $stmt->execute();
        $result = $stmt->get_result();
        
        $schedules = [];
        while ($row = $result->fetch_assoc()) {
            $schedules[] = $row;
        }
        
        echo json_encode([
            'status' => 'success',
            'data' => $schedules
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Loan ID is required.'
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid request method.'
    ]);
}
?>
