<?php
// Include database connection
require_once '../../config.php';

header('Content-Type: application/json');

$baseUrl = 'https://api.biasharademo.blmtec.co.tz/'; // Adjust the base URL if needed

// Check the request method
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (isset($_GET['loan_id'])) {
        $loanId = intval($_GET['loan_id']);
        fetchLoanDetails($loanId, $baseUrl);
    } else {
        fetchAllLoans($baseUrl);
    }
} else {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit();
}

function fetchAllLoans($baseUrl) {
    global $conn;

    $query = "
        SELECT l.id, l.user_id, l.product_id, l.full_name, l.phone_number, 
               l.national_id, l.reason, l.document_path, l.application_date, 
               l.status, l.weeks, l.total_loan_amount,
               u.first_name, u.last_name, 
               p.name AS product_name, p.cover_image AS product_cover_image
        FROM loan_applications l
        JOIN users u ON l.user_id = u.id
        JOIN product p ON l.product_id = p.id
        ORDER BY l.application_date DESC";

    $result = mysqli_query($conn, $query);

    if ($result) {
        $loans = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $loans[] = [
                'id' => $row['id'],
                'user_id' => $row['user_id'],
                'product_id' => $row['product_id'],
                'full_name' => $row['full_name'],
                'phone_number' => $row['phone_number'],
                'national_id' => $row['national_id'],
                'weeks' => $row['weeks'],
                'reason' => $row['reason'],
                'document_path' => $baseUrl . $row['document_path'],
                'application_date' => $row['application_date'],
                'status' => $row['status'],
                'user_name' => $row['first_name'] . ' ' . $row['last_name'],
                'product_name' => $row['product_name'],
                'product_cover_image' => $baseUrl . $row['product_cover_image'],
            ];
        }

        echo json_encode(['success' => true, 'loans' => $loans]);
    } else {
        http_response_code(500);
        echo json_encode(['success' => false, 'error' => 'Failed to fetch loans']);
    }
}

// Fetch loan details including payments
function fetchLoanDetails($loanId, $baseUrl) {
    global $conn;

    $query = "
        SELECT l.id, l.user_id, l.product_id, l.full_name, l.phone_number, 
               l.national_id, l.reason, l.document_path, l.application_date, 
               l.status, l.weeks, l.total_loan_amount,
               u.first_name, u.last_name, u.phone AS user_phone, 
               p.name AS product_name, p.description AS product_description, 
               p.cover_image AS product_cover_image, p.price, p.loan_price
        FROM loan_applications l
        JOIN users u ON l.user_id = u.id
        JOIN product p ON l.product_id = p.id
        WHERE l.id = $loanId";

    $result = mysqli_query($conn, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);

        // Fetch the initial deposit
        $depositQuery = "
            SELECT amount, deposit_date
            FROM initial_deposits
            WHERE loan_id = $loanId";
        $depositResult = mysqli_query($conn, $depositQuery);
        $deposit = mysqli_fetch_assoc($depositResult);

        // Fetch repayments
        $repaymentQuery = "
            SELECT amount, payment_date
            FROM repayments
            WHERE loan_id = $loanId";
        $repaymentResult = mysqli_query($conn, $repaymentQuery);
        $repayments = [];
        while ($repaymentRow = mysqli_fetch_assoc($repaymentResult)) {
            $repayments[] = $repaymentRow;
        }

        $loanDetails = [
            'id' => $row['id'],
            'user_id' => $row['user_id'],
            'product_id' => $row['product_id'],
            'full_name' => $row['full_name'],
            'phone_number' => $row['phone_number'],
            'national_id' => $row['national_id'],
            'weeks' => $row['weeks'],
            'reason' => $row['reason'],
            'document_path' => $baseUrl . $row['document_path'],
            'application_date' => $row['application_date'],
            'status' => $row['status'],
            'user_name' => $row['first_name'] . ' ' . $row['last_name'],
            'user_phone' => $row['user_phone'],
            'product_name' => $row['product_name'],
            'product_description' => $row['product_description'],
            'product_cover_image' => $baseUrl . $row['product_cover_image'],
            'product_price' => $row['price'],
            'product_loan_price' => $row['total_loan_amount'],
            'initial_deposit' => $deposit,
            'repayments' => $repayments,
        ];

        echo json_encode(['success' => true, 'loan' => $loanDetails]);
    } else {
        http_response_code(404);
        echo json_encode(['success' => false, 'error' => 'Loan not found']);
    }
}

?>
