<?php
// api/get_units.php
// NOTE: Make sure config.php does NOT print anything (no echoes, no whitespace before <?php).
header('Content-Type: application/json; charset=utf-8');

// CORS - allow all origins for testing; change to a specific origin in production.
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Origin, Content-Type, Accept, Authorization');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    // preflight request - just respond OK
    http_response_code(200);
    echo json_encode(['success' => true, 'message' => 'OK']);
    exit;
}

require_once '../../config.php'; // adjust path so it provides $conn (mysqli)

$response = ['success' => false, 'units' => []];

if (!isset($conn) || !$conn) {
    $response['message'] = 'Database connection not found.';
    echo json_encode($response);
    exit;
}

$sql = "SELECT `id`, `unit_name` FROM `units` ORDER BY `unit_name` ASC";
$result = $conn->query($sql);

if ($result) {
    $rows = [];
    while ($row = $result->fetch_assoc()) {
        $rows[] = [
            'id' => (int)$row['id'],
            'name' => $row['unit_name'],
        ];
    }
    $response['success'] = true;
    $response['units'] = $rows;
} else {
    $response['message'] = 'Query error: ' . $conn->error;
}

echo json_encode($response);
exit;
