<?php
header('Content-Type: application/json');
date_default_timezone_set('Africa/Dar_es_Salaam');
include '../../config.php';

// Pata tarehe ya leo kulingana na timezone ya server
$today = date("Y-m-d");

$sql = "SELECT o.id AS order_id, o.total_amount, o.order_date, o.shop_id, u.first_name, u.last_name, 
               oi.product_id, oi.quantity, oi.price, p.unit, p.name AS product_name, p.buy_price
        FROM orders o
        JOIN users u ON o.buyer_id = u.id
        JOIN order_items oi ON o.id = oi.order_id
        JOIN product p ON oi.product_id = p.id
        WHERE o.status IN (1,2)
        AND DATE(o.order_date) = '$today'";

$result = $conn->query($sql);

$orders = [];
while ($row = $result->fetch_assoc()) {
    $order_id = $row['order_id'];
    
    if (!isset($orders[$order_id])) {
        $orders[$order_id] = [
            'order_id' => $row['order_id'],
            'shop_id' => $row['shop_id'],
            'buyer_name' => $row['first_name'] . ' ' . $row['last_name'],
            'total_amount' => $row['total_amount'],
            'order_date' => $row['order_date'],
            'profit' => 0, // Anza na faida ya 0
            'capital' => 0,
            'items' => []
        ];
    }
    
    // Hesabu faida kwa kila item na kuongeza kwenye jumla ya oda
    $profit_per_item = $row['price'] - $row['buy_price'];
    $total_profit = $profit_per_item * $row['quantity'];
    $orders[$order_id]['profit'] += $total_profit;
    
    // Hesabu mtaji kwa kila item na kuongeza kwenye jumla ya oda
    $capital_per_item = $row['buy_price'];
    $total_capital = $capital_per_item * $row['quantity'];
    $orders[$order_id]['capital'] += $total_capital;

    $orders[$order_id]['items'][] = [
        'product_id' => $row['product_id'],
        'product_name' => $row['product_name'],
        'unit' => $row['unit'],
        'quantity' => $row['quantity'],
        'price' => $row['price']
    ];
}

echo json_encode(array_values($orders));

$conn->close();
?>
