<?php
date_default_timezone_set('Africa/Dar_es_Salaam');
include '../../config.php';

header('Content-Type: application/json');

// Get today's date and current month range
$today = date('Y-m-d');
$monthStart = date('Y-m-01'); // First day of the current month

// 1. Get total products with quantity > 0
$totalProductsQuery = "SELECT COUNT(*) AS total_products FROM product WHERE quantity > 0";
$totalProductsResult = mysqli_query($conn, $totalProductsQuery);
$totalProducts = mysqli_fetch_assoc($totalProductsResult)['total_products'];

// 2. Get products that are out of stock (quantity = 0)
$outOfStockProductsQuery = "SELECT COUNT(*) AS out_of_stock_products FROM product WHERE quantity = 0";
$outOfStockProductsResult = mysqli_query($conn, $outOfStockProductsQuery);
$outOfStockProducts = mysqli_fetch_assoc($outOfStockProductsResult)['out_of_stock_products'];

// 3. Get products with quantity below 5
$lowQuantityProductsQuery = "SELECT COUNT(*) AS low_quantity_products FROM product WHERE quantity < 5 AND quantity > 0";
$lowQuantityProductsResult = mysqli_query($conn, $lowQuantityProductsQuery);
$lowQuantityProducts = mysqli_fetch_assoc($lowQuantityProductsResult)['low_quantity_products'];

// 4. Get today's total sales
$totalSalesQuery = "SELECT SUM(total_amount) AS total_sales FROM orders WHERE DATE(order_date) = '$today' AND status IN (1, 2)";
$totalSalesResult = mysqli_query($conn, $totalSalesQuery);
$totalSalesRow = mysqli_fetch_assoc($totalSalesResult);
$totalSales = $totalSalesRow ? (float)$totalSalesRow['total_sales'] : 0;

// 5. Get today's profit
$todayProfitQuery = "SELECT SUM(oi.quantity * (oi.price - p.buy_price)) AS total_profit
    FROM order_items oi
    JOIN product p ON oi.product_id = p.id
    JOIN orders o ON oi.order_id = o.id
    WHERE DATE(o.order_date) = '$today' AND o.status IN (1, 2)";
$todayProfitResult = mysqli_query($conn, $todayProfitQuery);
$todayProfitRow = mysqli_fetch_assoc($todayProfitResult);
$totalProfit = $todayProfitRow ? (float)$todayProfitRow['total_profit'] : 0;

// 6. Get monthly total sales
$monthlySalesQuery = "SELECT SUM(total_amount) AS monthly_sales FROM orders WHERE order_date BETWEEN '$monthStart' AND '$today' AND status IN (1, 2)";
$monthlySalesResult = mysqli_query($conn, $monthlySalesQuery);
$monthlySalesRow = mysqli_fetch_assoc($monthlySalesResult);
$monthlySales = $monthlySalesRow ? (float)$monthlySalesRow['monthly_sales'] : 0;

// 7. Get monthly profit
$monthlyProfitQuery = "SELECT SUM(oi.quantity * (oi.price - p.buy_price)) AS monthly_profit
    FROM order_items oi
    JOIN product p ON oi.product_id = p.id
    JOIN orders o ON oi.order_id = o.id
    WHERE o.order_date BETWEEN '$monthStart' AND '$today' AND o.status IN (1, 2)";
$monthlyProfitResult = mysqli_query($conn, $monthlyProfitQuery);
$monthlyProfitRow = mysqli_fetch_assoc($monthlyProfitResult);
$monthlyProfit = $monthlyProfitRow ? (float)$monthlyProfitRow['monthly_profit'] : 0;


// 8. Get total users with status = 1 and role = 'cashier'
$totalCashiersQuery = "SELECT COUNT(*) AS total_cashiers FROM users WHERE status = '1' AND type = '1'";
$totalCashiersResult = mysqli_query($conn, $totalCashiersQuery);
$totalCashiersRow = mysqli_fetch_assoc($totalCashiersResult);
$totalCashiers = $totalCashiersRow ? (int)$totalCashiersRow['total_cashiers'] : 0;

// 9. Get total Customers 
$totalCustomersQuery = "SELECT COUNT(*) AS total_Customers FROM users WHERE status = '0' AND type = '0'";
$totalCustomersResult = mysqli_query($conn, $totalCustomersQuery);
$totalCustomersRow = mysqli_fetch_assoc($totalCustomersResult);
$totalCustomers = $totalCustomersRow ? (int)$totalCustomersRow['total_Customers'] : 0;

// 10. Get total Orders 
$totalOrdersQuery = "SELECT COUNT(*) AS total_Orders FROM orders WHERE status = '0'";
$totalOrdersResult = mysqli_query($conn, $totalOrdersQuery);
$totalOrdersRow = mysqli_fetch_assoc($totalOrdersResult);
$totalOrders = $totalOrdersRow ? (int)$totalOrdersRow['total_Orders'] : 0;


// Cast numeric values to floats to ensure proper number formatting in JSON
echo json_encode([
    'success' => true,
    'total_products' => (int)$totalProducts, // Integer
    'out_of_stock_products' => (int)$outOfStockProducts, // Integer
    'low_quantity_products' => (int)$lowQuantityProducts, // Integer for products with quantity < 5
    'total_sales' => (float)($totalSales), // Float with default to 0 if null
    'total_profit' => (float)($totalProfit), // Float with default to 0 if null
    'monthly_sales' => (float)($monthlySales), // Float with default to 0 if null
    'monthly_profit' => (float)($monthlyProfit), // Float with default to 0 if null
    'total_cashiers' => (int)$totalCashiers, // Integer
    'total_customers' => (int)$totalCustomers, // Integer
    'total_orders' => (int)$totalOrders, // Integer
]);
?>