<?php
header('Content-Type: application/json');
include '../../config.php';

// Chagua taarifa za staff pamoja na shop_id na shop_name (ikiwa ipo)
$sql = "SELECT u.id, u.first_name, u.last_name, u.phone, u.type, u.status, u.shop_id, s.name AS shop_name
        FROM users u
        LEFT JOIN shops s ON u.shop_id = s.id
        WHERE u.type IN (1, 2, 3)";

$result = $conn->query($sql);

// Angalia kama kuna rekodi zilizopatikana
if ($result->num_rows > 0) {
    $staffList = [];
    while ($row = $result->fetch_assoc()) {
        $staffList[] = [
            'id' => $row['id'],
            'name' => $row['first_name'] . ' ' . $row['last_name'], // Changanya first na last name
            'phone' => $row['phone'],
            'role' => $row['type'],
            'isActive' => $row['status'] == 1 ? true : false,
            'shop_id' => $row['shop_id'],     // Optional: shop id
            'shop_name' => $row['shop_name']    // Optional: shop name
        ];
    }
    echo json_encode(['staff' => $staffList]);
} else {
    echo json_encode(['staff' => []]);
}

// Funga connection
$conn->close();
?>
