<?php
header('Content-Type: application/json');
include '../../config.php'; // Ensure this file creates the $conn connection

// Fetch orders with supplier name only.
$sql = "SELECT so.id, so.supplier_id, so.status, so.created_at,
               s.name as supplier_name
        FROM stock_orders so
        JOIN suppliers s ON so.supplier_id = s.id
        ORDER BY so.created_at DESC";
$result = $conn->query($sql);

$orders = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $order_id = $row['id'];
        // Fetch order items for this order, including price and total.
        $sql_items = "SELECT id, order_id, item_name, item_quantity, item_price, item_total 
                      FROM stock_order_items WHERE order_id = '$order_id'";
        $itemsResult = $conn->query($sql_items);
        $items = [];
        if ($itemsResult->num_rows > 0) {
            while ($itemRow = $itemsResult->fetch_assoc()) {
                $items[] = $itemRow;
            }
        }
        $orders[] = [
            'id' => $row['id'],
            'supplier_id' => $row['supplier_id'],
            'status' => $row['status'],
            'created_at' => $row['created_at'],
            'supplier' => [
                'name' => $row['supplier_name']
            ],
            'items' => $items
        ];
    }
}
echo json_encode($orders);
$conn->close();
?>
