<?php
header("Content-Type: application/json");

include '../../config.php';  // Include your database connection

if (isset($_GET['invoice_id'])) {
    $invoiceId = mysqli_real_escape_string($conn, $_GET['invoice_id']);
    
    // Fetch specific invoice with additional fields
    $invoiceQuery = "SELECT id, invoice_number, seller_phone, customer_name, address, contact_info, total_amount, tax, status, tin_number, vrn_number, type, created_at 
                     FROM invoices WHERE id = $invoiceId";
    $invoiceResult = mysqli_query($conn, $invoiceQuery);
    
    if ($invoiceResult && mysqli_num_rows($invoiceResult) > 0) {
        $invoice = mysqli_fetch_assoc($invoiceResult);
        
        // Fetch items
        $itemsQuery = "SELECT id, invoice_id, item_name, description, quantity, price 
                       FROM invoice_items WHERE invoice_id = $invoiceId";
        $itemsResult = mysqli_query($conn, $itemsQuery);
        $items = [];
        $subtotal = 0;
        while ($item = mysqli_fetch_assoc($itemsResult)) {
            $items[] = $item;
            $subtotal += $item['quantity'] * $item['price'];  // Calculate the subtotal
        }

        // Calculate grand total (subtotal + tax)
        $grandTotal = $subtotal + $invoice['tax'];

        $response = [
            'status' => 'success',
            'invoice' => $invoice,
            'items' => $items,
            'subtotal' => $subtotal,  // Add subtotal to the response
            'grand_total' => $grandTotal  // Add grand total to the response
        ];
    } else {
        $response = ['status' => 'error', 'message' => 'Invoice not found'];
    }
} else {
    // Fetch all invoices in descending order by created_at date
    $invoiceQuery = "SELECT id, invoice_number, seller_phone, customer_name, address, total_amount, status, tin_number, vrn_number, type, created_at 
                     FROM invoices ORDER BY created_at DESC";  // Sorting by created_at in DESC order
    $invoiceResult = mysqli_query($conn, $invoiceQuery);
    $invoices = [];
    
    while ($invoice = mysqli_fetch_assoc($invoiceResult)) {
        $invoices[] = $invoice;
    }

    $response = [
        'status' => 'success',
        'invoices' => $invoices
    ];
}

echo json_encode($response);
mysqli_close($conn);
?>
