<?php
include '../../config.php';

// Weka timezone ya Dar es Salaam
date_default_timezone_set('Africa/Dar_es_Salaam');

header("Content-Type: application/json");

$today = date("Y-m-d"); // Pata tarehe ya leo

// Hakuna hitaji ya user_id sasa, tunachunguza tu tarehe ya leo
$stmt = $conn->prepare("SELECT * FROM expenses WHERE DATE(created_at) = ? ORDER BY created_at DESC");
$stmt->bind_param("s", $today);
$stmt->execute();
$result = $stmt->get_result();

$expenses = [];
while ($row = $result->fetch_assoc()) {
    $expenses[] = $row;
}

echo json_encode(["success" => true, "data" => $expenses]);
?>
