<?php
include '../../config.php';

// Weka timezone ya Dar es Salaam
date_default_timezone_set('Africa/Dar_es_Salaam');

header("Content-Type: application/json");

$user_id = $_GET['user_id'];
$today = date("Y-m-d"); // Pata tarehe ya leo

if (!empty($user_id)) {
    // Badilisha query ili iwe na vigezo vya user_id na tarehe ya leo
    $stmt = $conn->prepare("SELECT * FROM expenses WHERE user_id = ? AND DATE(created_at) = ? ORDER BY created_at DESC");
    $stmt->bind_param("is", $user_id, $today);
    $stmt->execute();
    $result = $stmt->get_result();

    $expenses = [];
    while ($row = $result->fetch_assoc()) {
        $expenses[] = $row;
    }

    echo json_encode(["success" => true, "data" => $expenses]);
} else {
    echo json_encode(["success" => false, "message" => "User ID inahitajika"]);
}
?>
