<?php
header('Content-Type: application/json');

include '../../config.php';

// Prepare SQL to fetch staff records with first and last name for type 1 or 2
$sql = "SELECT id, first_name, last_name, phone, type, status 
        FROM users 
        WHERE type IN (0, 0, 0)"; // Filter by type 1 or 2

$result = $conn->query($sql);

// Check if records are found
if ($result->num_rows > 0) {
    $staffList = [];
    while ($row = $result->fetch_assoc()) {
        $staffList[] = [
            'id' => $row['id'],
            'name' => $row['first_name'] . ' ' . $row['last_name'], // Combine first and last name
            'phone' => $row['phone'],
            'role' => $row['type'],
            'isActive' => $row['status'] == 0 ? true : false
        ];
    }
    echo json_encode(['staff' => $staffList]);
} else {
    echo json_encode(['staff' => []]);
}

// Close the database connection
$conn->close();
?>
