<?php
header('Content-Type: application/json; charset=utf-8');
include_once '../../config.php'; // Adjust path if needed; file must set $conn (mysqli)

$response = ['success' => false, 'categories' => []];

if (!isset($conn) || !$conn) {
    $response['message'] = 'Database connection not found.';
    echo json_encode($response);
    exit;
}

$sql = "SELECT `id`, `category_name` FROM `categories` ORDER BY `category_name` ASC";
$result = $conn->query($sql);

if ($result) {
    $rows = [];
    while ($row = $result->fetch_assoc()) {
        $rows[] = [
            'id' => (int)$row['id'],
            'name' => $row['category_name'],
        ];
    }
    $response['success'] = true;
    $response['categories'] = $rows;
} else {
    $response['message'] = 'Query error: ' . $conn->error;
}

echo json_encode($response);
