<?php
header('Content-Type: application/json');

include '../../config.php';

$sql = "SELECT u.id, u.first_name, u.last_name, u.phone, u.type, u.status, u.shop_id, s.name AS shop_name
        FROM users u
        LEFT JOIN shops s ON u.shop_id = s.id
        WHERE u.type IN (1)"; 

$result = $conn->query($sql);

// Check if records are found
if ($result->num_rows > 0) {
    $staffList = [];
    while ($row = $result->fetch_assoc()) {
        $staffList[] = [
            'id' => $row['id'],
            'name' => $row['first_name'] . ' ' . $row['last_name'],
            'phone' => $row['phone'],
            'role' => $row['type'],
            'isActive' => $row['status'] == 1 ? true : false,
            'shop_id' => $row['shop_id'],
            'shop_name' => $row['shop_name']
        ];
    }
    echo json_encode(['staff' => $staffList]);
} else {
    echo json_encode(['staff' => []]);
}

// Close the database connection
$conn->close();
?>
