<?php
include_once '../../config.php';

header("Content-Type: application/json; charset=UTF-8");

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (isset($_GET['order_id'])) {
        $orderId = intval($_GET['order_id']);
        $query = "
            SELECT 
                oi.order_id,
                p.name AS product_name,
                p.unit,
                oi.quantity,
                oi.price
            FROM order_items oi
            INNER JOIN product p ON oi.product_id = p.id
            WHERE oi.order_id = $orderId
        ";

        $result = $conn->query($query);
        $orderItems = [];

        if ($result && $result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $orderItems[] = $row;
            }
        }

        echo json_encode([
            "success" => true,
            "data" => $orderItems
        ]);
    } else {
        $query = "
            SELECT 
                o.id AS order_id,
                u.first_name,
                u.last_name,
                u.phone,
                u.email,
                o.total_amount,
                o.order_date,
                o.status
            FROM orders o
            INNER JOIN users u ON o.buyer_id = u.id
            WHERE o.status IN (1, 2)
        ";

        $result = $conn->query($query);
        $receipts = [];

        if ($result && $result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $receipts[] = $row;
            }
        }

        echo json_encode([
            "success" => true,
            "data" => $receipts
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method."
    ]);
}

$conn->close();
?>
