<?php
include '../../config.php';

header('Content-Type: application/json');

// Define the base URL for the images
$baseUrl = 'https://api.almega.co.tz/'; // Adjust the base path if needed

// Angalia kama shop_id imetumwa
if (isset($_GET['shop_id']) && is_numeric($_GET['shop_id'])) {
    $shopId = intval($_GET['shop_id']);
    $sql = "SELECT id, name, cover_image, old_price, price, buy_price, loan_price, description, category, quantity, orders, unit, shop_id 
            FROM product 
            WHERE shop_id = $shopId
            ORDER BY created_at DESC";
} else {
    $sql = "SELECT id, name, cover_image, old_price, price, buy_price, loan_price, description, category, quantity, orders, unit, shop_id 
            FROM product 
            ORDER BY created_at DESC";
}

$result = $conn->query($sql);

$products = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $orders = $row['orders'];
        $shopId = $row['shop_id'];

        // Generate a random rating based on orders
        $rating = 2 + (mt_rand() / mt_getrandmax()) * 3; 

        // Ikiwa cover_image ni null au empty, weka default image
        $coverImage = !empty($row['cover_image']) ? $row['cover_image'] : 'uploads/logo.png';

        $products[] = [
            'id' => $row['id'],
            'name' => $row['name'],
            'description' => $row['description'],
            'imageUrl' => $baseUrl . $coverImage,
            'price' => (float)$row['price'],
            'oldPrice' => (float)$row['old_price'],
            'loanPrice' => (float)$row['loan_price'],
            'buyPrice' => (float)$row['buy_price'],
            'quantity' => (float)$row['quantity'],
            'orders' => (int)$orders,
            'shop' => (int)$shopId,
            'category' => $row['category'],
            'unit' => $row['unit'],
        ];
    }
}

echo json_encode(['products' => $products]);

$conn->close();
?>
