<?php
include '../../config.php'; // Database connection

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Decode the JSON input
    $input = json_decode(file_get_contents('php://input'), true);
    
    // Check if required fields exist
    if (isset($input['userId']) && isset($input['password'])) {
        $userId = $input['userId'];
        $newPassword = $input['password'];

        if (!empty($userId) && !empty($newPassword)) {
            // Hash the password
            $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);

            // Update the password in the database
            $sql = "UPDATE users SET password = ? WHERE id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("si", $hashedPassword, $userId);

            if ($stmt->execute()) {
                echo json_encode(['status' => 'success', 'message' => 'Password updated']);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Password update failed']);
            }

            $stmt->close();
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Invalid input']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Missing userId or password']);
    }
}

$conn->close();
?>
