<?php
date_default_timezone_set('Africa/Dar_es_Salaam');
include '../../config.php'; // Badilisha kama inahitajika

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Soma raw input na uipakue kama JSON
    $data = json_decode(file_get_contents("php://input"), true);

    if (isset($data['id'])) {
        $product_id = $data['id'];

        $stmt = $conn->prepare("SELECT name, quantity FROM product WHERE id = ?");
        $stmt->bind_param("i", $product_id);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $product = $result->fetch_assoc();
            $product_name = $product['name'];
            $quantity = $product['quantity'];

            $insert_stmt = $conn->prepare("INSERT INTO deleted_items (product_id, product_name, quantity) VALUES (?, ?, ?)");
            $insert_stmt->bind_param("isi", $product_id, $product_name, $quantity);
            $insert_stmt->execute();

            $delete_stmt = $conn->prepare("DELETE FROM product WHERE id = ?");
            $delete_stmt->bind_param("i", $product_id);
            if ($delete_stmt->execute()) {
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to delete product.']);
            }

            $insert_stmt->close();
            $delete_stmt->close();
        } else {
            echo json_encode(['success' => false, 'message' => 'Product not found.']);
        }

        $stmt->close();
        $conn->close();
    } else {
        echo json_encode(['success' => false, 'message' => 'Product ID not provided.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
}
?>
