<?php
// delete_pending_order.php

include('../../config.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['order_id'])) {
        $order_id = $_POST['order_id'];
        
        // Anza transaction
        $conn->begin_transaction();
        
        // Kwanza, futa order items zinazohusiana na order_id
        $sqlItems = "DELETE FROM order_items WHERE order_id = ?";
        $stmtItems = $conn->prepare($sqlItems);
        $stmtItems->bind_param("s", $order_id);
        
        if(!$stmtItems->execute()){
            $conn->rollback();
            echo json_encode(["success" => false, "message" => "Failed to delete order items."]);
            exit;
        }
        
        // Kisha, futa order ikiwa status ni Pending (0)
        $sqlOrder = "DELETE FROM orders WHERE id = ? AND status = 0";
        $stmtOrder = $conn->prepare($sqlOrder);
        $stmtOrder->bind_param("s", $order_id);
        
        if(!$stmtOrder->execute()){
            $conn->rollback();
            echo json_encode(["success" => false, "message" => "Failed to delete order."]);
            exit;
        }
        
        $conn->commit();
        echo json_encode(["success" => true, "message" => "Order deleted successfully."]);
    } else {
        echo json_encode(["success" => false, "message" => "No order id provided."]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method."]);
}
?>
