<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $order_id = $_POST['order_id'] ?? '';

    if (!empty($order_id)) {
        // Delete order items first
        $delete_items = $conn->prepare("DELETE FROM order_items WHERE order_id = ?");
        $delete_items->bind_param("i", $order_id);
        $delete_items->execute();
        $delete_items->close();

        // Delete order from orders table
        $delete_order = $conn->prepare("DELETE FROM orders WHERE id = ?");
        $delete_order->bind_param("i", $order_id);
        $delete_order->execute();
        
        if ($delete_order->affected_rows > 0) {
            echo json_encode(["success" => true, "message" => "Order deleted successfully"]);
        } else {
            echo json_encode(["success" => false, "message" => "Order not found or already deleted"]);
        }

        $delete_order->close();
    } else {
        echo json_encode(["success" => false, "message" => "Order ID is required"]);
    }
}

$conn->close();
?>
