<?php
header('Content-Type: application/json');
include '../../config.php';

// Angalia kama umefika na method POST, vinginevyo jaribu GET
$expenses_id = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['expenses_id'])) {
        $expenses_id = intval($_POST['expenses_id']);
    }
} else if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (isset($_GET['expenses_id'])) {
        $expenses_id = intval($_GET['expenses_id']);
    }
}

if ($expenses_id === null) {
    echo json_encode(array("success" => false, "message" => "Expense ID not provided."));
    exit;
}

$sql = "DELETE FROM expenses WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $expenses_id);

if($stmt->execute()){
    echo json_encode(array("success" => true, "message" => "Expense deleted successfully."));
} else {
    echo json_encode(array("success" => false, "message" => "Failed to delete expense."));
}

$stmt->close();
$conn->close();
?>
