<?php
// delete_customer.php

// Hakikisha una connection ya database
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['user_id'])) {
        $user_id = intval($_POST['user_id']);
        
        // Andika query ya ku-delete, badilisha 'customers' na jina la table yako
        $sql = "DELETE FROM users WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $user_id);

        if($stmt->execute()){
            echo json_encode(array("success" => true, "message" => "Customer deleted successfully."));
        } else {
            echo json_encode(array("success" => false, "message" => "Failed to delete customer."));
        }
    } else {
        echo json_encode(array("success" => false, "message" => "No user id provided."));
    }
} else {
    echo json_encode(array("success" => false, "message" => "Invalid request method."));
}
?>
