<?php
include '../../config.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
    // Get content ID from URL
    parse_str(parse_url($_SERVER['REQUEST_URI'], PHP_URL_QUERY), $params);
    $contentId = $params['id'] ?? null;

    if ($contentId) {
        try {
            // Delete content from database
            $query = "DELETE FROM course_contents WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $contentId);
            $stmt->execute();

            if ($stmt->affected_rows > 0) {
                echo json_encode(['success' => true, 'message' => 'Content deleted successfully.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Content not found or already deleted.']);
            }
        } catch (Exception $e) {
            echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid content ID.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
}
?>
