<?php
// Database connection
include('../../config.php');

// Retrieve loan ID and status
$loan_id = $_POST['loan_id'];
$status = $_POST['status']; // 'approved' or 'rejected'

// Check if the loan ID and status are provided
if (empty($loan_id) || empty($status)) {
    echo json_encode(['status' => 'error', 'message' => 'Loan ID and status are required.']);
    exit;
}

// Validate status (approved or rejected)
if ($status != 'approved' && $status != 'rejected') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid status.']);
    exit;
}

// Update the loan status in the database
$query = "UPDATE loan_applications SET status = '$status' WHERE id = '$loan_id'";
$result = mysqli_query($conn, $query);

if ($result && $status == 'approved') {
    // Fetch loan details
    $loan_query = "SELECT user_id, weeks, application_date, total_loan_amount FROM loan_applications WHERE id = '$loan_id'";
    $loan_result = mysqli_query($conn, $loan_query);
    $loan = mysqli_fetch_assoc($loan_result);

    if ($loan) {
        $user_id = $loan['user_id'];
        $weeks = $loan['weeks'];
        $application_date = $loan['application_date'];
        $loan_amount = $loan['total_loan_amount'];

        // Calculate scheduled amount
        $scheduled_amount = round($loan_amount / $weeks, 2);

        // Create loan repayment schedule
        $current_date = new DateTime($application_date);
        for ($i = 0; $i < $weeks; $i++) {
            $current_date->modify('+1 week');
            $repayment_date = $current_date->format('Y-m-d');

            $schedule_query = "INSERT INTO loan_schedule (user_id, loan_id, status, date, scheduled_amount)
                               VALUES ('$user_id', '$loan_id', 'pending', '$repayment_date', '$scheduled_amount')";
            mysqli_query($conn, $schedule_query);
        }
    }

    echo json_encode(['status' => 'success', 'message' => 'Loan approved and schedule created successfully.']);
} elseif ($result) {
    echo json_encode(['status' => 'success', 'message' => 'Loan status updated successfully.']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to update loan status.']);
}

mysqli_close($conn);
?>
